package ru.yandex.autotests.directapi.model.api5.bids;

import com.yandex.direct.api.v5.bids.BidActionResult;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ExceptionNotificationMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 13.08.14.
 */
public class BidActionResultMap extends ModelBeanMap<BidActionResultMap> {

    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String WARNINGS = "warnings";
    public static final String ERRORS = "errors";

    public BidActionResultMap() {
        super();
        setBean(new BidActionResult());
    }

    public BidActionResultMap(BidActionResult actionResult) {
        super();
        setBean(actionResult);
    }

    public BidActionResultMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidActionResultMap withKeywordId(Long id) {
        this.put(KEYWORD_ID, id);
        return this;
    }

    public BidActionResultMap withAdGroupId(Long id) {
        this.put(AD_GROUP_ID, id);
        return this;
    }

    public BidActionResultMap withCampaignId(Long id) {
        this.put(CAMPAIGN_ID, id);
        return this;
    }

    public BidActionResultMap withWarnings(ExceptionNotificationMap... warnings) {
        this.put(WARNINGS, (warnings == null) ? null : convert(warnings, new BeanMapToBeanConverter()));
        return this;
    }

    public BidActionResultMap withErrors(ExceptionNotificationMap... errors) {
        this.put(ERRORS, (errors == null) ? null : convert(errors, new BeanMapToBeanConverter()));
        return this;
    }
}
