package ru.yandex.autotests.directapi.model.api5.bids;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 13.08.14.
 */
public class BidBaseMap<T> extends ModelBeanMap<BidBaseMap> {

    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";

    public BidBaseMap() {
        super();
    }

    public BidBaseMap withKeywordId(Long id) {
        this.put(KEYWORD_ID, id);
        return this;
    }

    public BidBaseMap withAdGroupId(Long id) {
        this.put(AD_GROUP_ID, id);
        return this;
    }

    public BidBaseMap withCampaignId(Long id) {
        this.put(CAMPAIGN_ID, id);
        return this;
    }

}
