package ru.yandex.autotests.directapi.model.api5.bids;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.BidSetAutoItem;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 04.07.14.
 */
public class BidSetAutoItemMap extends ModelBeanMap<BidSetAutoItemMap> {
    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String POSITION = "position";
    public static final String MAX_BID = "maxBid";
    public static final String INCREASE_PERCENT = "increasePercent";
    public static final String CALCULATE_BY = "calculateBy";
    public static final String CONTEXT_COVERAGE = "contextCoverage";
    public static final String SCOPE = "scope";

    public BidSetAutoItemMap() {
        super();
        setBean(new BidSetAutoItem());
    }

    public BidSetAutoItemMap(BidSetAutoItem bids) {
        super();
        setBean(bids);
    }

    public BidSetAutoItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidSetAutoItemMap withKeywordId(Long keywordsIds) {
        this.put(KEYWORD_ID, keywordsIds);
        return this;
    }

    public BidSetAutoItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public BidSetAutoItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public BidSetAutoItemMap withMaxBid(Long maxBid) {
        this.put(MAX_BID, maxBid);
        return this;
    }

    public BidSetAutoItemMap withPosition(PositionEnum position) {
        this.put(POSITION, position);
        return this;
    }

    public BidSetAutoItemMap withIncreasePercent(Integer increasePercent) {
        this.put(INCREASE_PERCENT, increasePercent);
        return this;
    }

    public BidSetAutoItemMap withCalculateBy(CalculateByEnum calculateBy) {
        this.put(CALCULATE_BY, calculateBy);
        return this;
    }

    public BidSetAutoItemMap withContextCoverage(Integer contextCoverage) {
        this.put(CONTEXT_COVERAGE, contextCoverage);
        return this;
    }

    public BidSetAutoItemMap withScope(ScopeEnum... scope) {
        this.put(SCOPE, Arrays.asList(scope));
        return this;
    }
}
