package ru.yandex.autotests.directapi.model.api5.bids;

import com.yandex.direct.api.v5.bids.BidSetItem;
import com.yandex.direct.api.v5.general.PriorityEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 04.07.14.
 */
public class BidSetItemMap extends ModelBeanMap<BidSetItemMap> {
    public static final String KEYWORD_ID = "keywordId";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CAMPAIGN_ID = "campaignId";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";

    public BidSetItemMap() {
        super();
        setBean(new BidSetItem());
    }

    public BidSetItemMap(BidSetItem bids) {
        super();
        setBean(bids);
    }

    public BidSetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidSetItemMap withKeywordId(Long keywordsIds) {
        this.put(KEYWORD_ID, keywordsIds);
        return this;
    }

    public BidSetItemMap withAdGroupId(Long adGroupId) {
        this.put(AD_GROUP_ID, adGroupId);
        return this;
    }

    public BidSetItemMap withCampaignId(Long campaignId) {
        this.put(CAMPAIGN_ID, campaignId);
        return this;
    }

    public BidSetItemMap withBid(Long bid) {
        this.put(BID, bid);
        return this;
    }

    public BidSetItemMap withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public BidSetItemMap withStrategyPriority(PriorityEnum strategyPriority) {
        this.put(STRATEGY_PRIORITY, strategyPriority);
        return this;
    }
}
