package ru.yandex.autotests.directapi.model.api5.bids;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.general.ServingStatusEnum;

/**
 * Created by ginger on 12.08.14.
 */
public class BidsGetItemMap extends BidBaseMap<BidsGetItemMap> {
    public static final String BID = "bid";
    public static final String KEYWORD_ID = "keywordId";
    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String COMPETITORS_BIDS = "competitorsBids";
    public static final String SEARCH_PRICES = "searchPrices";
    public static final String CONTEXT_COVERAGE = "contextCoverage";
    public static final String MIN_SEARCH_PRICE = "minSearchPrice";
    public static final String CURRENT_SEARCH_PRICE = "currentSearchPrice";
    public static final String AUCTION_BIDS = "auctionBids";
    public static final String SERVING_STATUS = "servingStatus";

    public BidsGetItemMap() {
        super();
        setBean(new BidGetItem());
    }

    public BidsGetItemMap(BidGetItem bidGetItem) {
        super();
        setBean(bidGetItem);
    }

    public BidsGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }


    public BidsGetItemMap withKeywordId(Long keywordId) {
        this.put(KEYWORD_ID, keywordId);
        return this;
    }

    public BidsGetItemMap withBid(Long bid) {
        this.put(BID, bid);
        return this;
    }

    public BidsGetItemMap withContextBid(Long contextBid) {
        this.put(CONTEXT_BID, contextBid);
        return this;
    }

    public BidsGetItemMap withStrategyPriority(JAXBElement priority) {
        this.put(STRATEGY_PRIORITY, priority);
        return this;
    }

    public BidsGetItemMap withCompetitorsBids(JAXBElement competitorsBids) {
        this.put(COMPETITORS_BIDS, competitorsBids);
        return this;
    }

    public BidsGetItemMap withSearchPrices(JAXBElement searchPrices) {
        this.put(SEARCH_PRICES, searchPrices);
        return this;
    }

    public BidsGetItemMap withMinSearchPrice(JAXBElement minSearchPrice) {
        this.put(MIN_SEARCH_PRICE, minSearchPrice);
        return this;
    }

    public BidsGetItemMap withContextCoverage(JAXBElement contextCoverage) {
        this.put(CONTEXT_COVERAGE, contextCoverage);
        return this;
    }

    public BidsGetItemMap withCurrentSearchPrice(JAXBElement currentSearchPrice) {
        this.put(CURRENT_SEARCH_PRICE, currentSearchPrice);
        return this;
    }

    public BidsGetItemMap withAuctionBids(JAXBElement auctionBids) {
        this.put(AUCTION_BIDS, auctionBids);
        return this;
    }

    public BidsGetItemMap withServingStatus(ServingStatusEnum servingStatus) {
        this.put(SERVING_STATUS, servingStatus);
        return this;
    }

}
