package ru.yandex.autotests.directapi.model.api5.bids;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.BidsSelectionCriteria;
import com.yandex.direct.api.v5.general.ServingStatusEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 04.07.14.
 */
public class BidsSelectionCriteriaMap extends ModelBeanMap<BidsSelectionCriteriaMap> {

    public static final String KEYWORDS_IDS = "keywordIds";
    public static final String ADGROUP_IDS = "adGroupIds";
    public static final String CAMPAIGN_IDS = "campaignIds";
    public static final String SERVING_STATUSES = "servingStatuses";

    public BidsSelectionCriteriaMap() {
        super();
        setBean(new BidsSelectionCriteria());
    }

    public BidsSelectionCriteriaMap(BidsSelectionCriteria bidsSelectionCriteria) {
        super();
        setBean(bidsSelectionCriteria);
    }

    public BidsSelectionCriteriaMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public BidsSelectionCriteriaMap withKeywordIds(Long... keywordsIds) {
        this.put(KEYWORDS_IDS, Arrays.asList(keywordsIds));
        return this;
    }

    public BidsSelectionCriteriaMap withCampaignIds(Long... camapignIds) {
        this.put(CAMPAIGN_IDS, Arrays.asList(camapignIds));
        return this;
    }

    public BidsSelectionCriteriaMap withAdGroupIds(Long... adGroupIds) {
        this.put(ADGROUP_IDS, Arrays.asList(adGroupIds));
        return this;
    }

    public BidsSelectionCriteriaMap withServingStatuses(ServingStatusEnum... servingStatuses) {
        this.put(SERVING_STATUSES, Arrays.asList(servingStatuses));
        return this;
    }
}
