package ru.yandex.autotests.directapi.model.api5.bids;

import com.yandex.direct.api.v5.bids.ContextCoverageItem;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 20.08.15.
 */
public class ContextCoverageItemMap extends ModelBeanMap<ContextCoverageItemMap> {
    public static final String PROBABILITY = "probability";
    public static final String PRICE = "price";


    public ContextCoverageItemMap() {
        super();
        setBean(new ContextCoverageItem());
    }

    public ContextCoverageItemMap(ContextCoverageItem contextCoverageItem) {
        super();
        setBean(contextCoverageItem);
    }

    public ContextCoverageItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ContextCoverageItemMap withProbability(String probability) {
        this.put(PROBABILITY, probability);
        return this;
    }

    public ContextCoverageItemMap withPrice(Long price) {
        this.put(PRICE, price);
        return this;
    }
}
