package ru.yandex.autotests.directapi.model.api5.bids;

import com.yandex.direct.api.v5.bids.SetAutoRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 04.07.14.
 */
public class SetAutoRequestMap extends ModelBeanMap<SetAutoRequestMap> {

    public static final String BIDS = "bids";

    public SetAutoRequestMap() {
        super();
        setBean(new SetAutoRequest());
    }

    public SetAutoRequestMap(SetAutoRequest setRequest) {
        super();
        setBean(setRequest);
    }

    public SetAutoRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SetAutoRequestMap withBids(BidSetAutoItemMap... bids) {
        this.put(BIDS, (bids == null) ? null : convert(bids, new BeanMapToBeanConverter()));
        return this;
    }
}
