package ru.yandex.autotests.directapi.model.api5.bids;

import com.yandex.direct.api.v5.bids.SetRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by ginger on 04.07.14.
 */
public class SetRequestMap extends ModelBeanMap<SetRequestMap> {

    public static final String BIDS = "bids";

    public SetRequestMap() {
        super();
        setBean(new SetRequest());
    }

    public SetRequestMap(SetRequest setRequest) {
        super();
        setBean(setRequest);
    }

    public SetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SetRequestMap withBids(BidSetItemMap... bids) {
        this.put(BIDS, (bids == null) ? null : convert(bids, new BeanMapToBeanConverter()));
        return this;
    }
}
