package ru.yandex.autotests.directapi.model.api5.businesses;

import com.yandex.direct.api.v5.businesses.BusinessGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class BusinessesGetItemMap extends ModelBeanMap<BusinessesGetItemMap> {

    public static final String ID = "id";
    public static final String IS_ACCESSIBLE = "isAccessible";

    public BusinessesGetItemMap() {
        super();
        setBean(new BusinessGetItem());
    }

    public BusinessesGetItemMap(BusinessGetItem businessGetItem) {
        super();
        setBean(businessGetItem);
    }

    public BusinessesGetItemMap withId(Long id) {
        put(ID, id);
        return this;
    }

    public BusinessesGetItemMap withIsAccessible(YesNoEnum isAccessible) {
        put(IS_ACCESSIBLE, isAccessible);
        return this;
    }
}
