package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.AddRequest;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 05.08.15.
 */
public class AddRequestMap extends ModelBeanMap<AddRequestMap> {

    public static final String CAMPAIGNS = "campaigns";

    public static final int MAX_AMOUNT_OF_CAMPAIGNS_IN_REQUEST = 10;

    public AddRequestMap() {
        super();
        setBean(new AddRequest());
    }

    public AddRequestMap(AddRequest addRequest) {
        super();
        setBean(addRequest);
    }

    public AddRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public AddRequestMap withCampaigns(CampaignAddItemMap... campaigns) {
        this.put(CAMPAIGNS, (campaigns == null) ? null : convert(campaigns, new BeanMapToBeanConverter()));
        return this;
    }
}
