package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.CampaignAssistant;
import com.yandex.direct.api.v5.campaigns.ObjectFactory;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 18.08.15.
 */
public class CampaignAssistantMap extends ModelBeanMap<CampaignAssistantMap> {

    public static final String MANAGER = "manager";
    public static final String AGENCY = "agency";

    public CampaignAssistantMap() {
        super();
        setBean(new CampaignAssistant());
    }

    public CampaignAssistantMap(CampaignAssistant campaignAssistant) {
        super();
        setBean(campaignAssistant);
    }

    public CampaignAssistantMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CampaignAssistantMap withAgency(String agency) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createCampaignAssistantAgency(agency);
        this.put(AGENCY, jaxbElement);
        return this;
    }

    public CampaignAssistantMap withManager(String manager) {
        JAXBElement<String> jaxbElement =
                new ObjectFactory().createCampaignAssistantManager(manager);
        this.put(MANAGER, jaxbElement);
        return this;
    }
}
