package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CampaignFundsParam;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 26.08.15.
 */
public class CampaignFundsParamMap extends ModelBeanMap<CampaignFundsParamMap> {

    public static final String SUM = "sum";
    public static final String BALANCE = "balance";
    public static final String BALANCE_BONUS = "balanceBonus";
    public static final String SUM_AVAILABLE_FOR_TRANSFER = "sumAvailableForTransfer";

    public CampaignFundsParamMap() {
        super();
        setBean(new CampaignFundsParam());
    }

    public CampaignFundsParamMap(CampaignFundsParam funds) {
        super();
        setBean(funds);
    }

    public CampaignFundsParamMap withSum(Long sum) {
        this.put(SUM, sum);
        return this;
    }

    public CampaignFundsParamMap withBalance(Long balance) {
        this.put(BALANCE, balance);
        return this;
    }

    public CampaignFundsParamMap withBalanceBonus(Long balanceBonus) {
        this.put(BALANCE_BONUS, balanceBonus);
        return this;
    }

    public CampaignFundsParamMap withSumAvailableForTransfer(Long sumAvailableForTransfer) {
        this.put(SUM_AVAILABLE_FOR_TRANSFER, sumAvailableForTransfer);
        return this;
    }
}
