package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignStrategyAdd;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.VideoTargetEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignAddItemMap extends ModelBeanMap<CpmBannerCampaignAddItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String COUNTER_IDS = "counterIds";
    public static final String FREQUENCY_CAP = "frequencyCap";
    public static final String VIDEO_TARGET = "videoTarget";

    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;

    public CpmBannerCampaignAddItemMap() {
        super();
        setBean(new CpmBannerCampaignAddItem());
    }

    public CpmBannerCampaignAddItemMap(CpmBannerCampaignAddItem cpmBannerCampaignAddItem) {
        super();
        setBean(cpmBannerCampaignAddItem);
    }

    public CpmBannerCampaignAddItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignAddItemMap withBiddingStrategy(
            CpmBannerCampaignStrategyAddMap cpmBannerCampaignStrategyAddMap)
    {
        CpmBannerCampaignStrategyAdd cpmBannerCampaignStrategyAdd =
                ((cpmBannerCampaignStrategyAddMap == null) ? null
                        : (CpmBannerCampaignStrategyAdd) (cpmBannerCampaignStrategyAddMap.getBean()));
        this.put(BIDDING_STRATEGY, cpmBannerCampaignStrategyAdd);
        return this;
    }

    public CpmBannerCampaignAddItemMap withSettings(CpmBannerCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public CpmBannerCampaignAddItemMap withFrequencyCap(FrequencyCapSettingAddMap frequencyCap) {
        this.put(FREQUENCY_CAP, (frequencyCap == null) ? null : frequencyCap.getBean());
        return this;
    }

    public CpmBannerCampaignAddItemMap defaultCpmBannerCampaign() {
        return this.withBiddingStrategy(new CpmBannerCampaignStrategyAddMap().defaultCpmBannerCampaignStrategy());
    }

    public CpmBannerCampaignAddItemMap withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        return this.put(COUNTER_IDS, counterIds);
    }

    public CpmBannerCampaignAddItemMap withCounterIds(Integer... items) {
        ArrayOfIntegerMap arrayOfIntegerMap = (items == null) ? null : new ArrayOfIntegerMap().withItems(items);
        return this.withCounterIds(arrayOfIntegerMap);
    }

    public CpmBannerCampaignAddItemMap withVideoTarget(VideoTargetEnum videoTarget) {
        this.put(VIDEO_TARGET, videoTarget);
        return this;
    }
}
