package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.FrequencyCapSetting;
import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.general.ArrayOfInteger;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignBaseMap<T> extends ModelBeanMap<CpmBannerCampaignBaseMap> {

    public static final String COUNTER_IDS = "counterIds";
    public static final String FREQUENCY_CAP = "frequencyCap";

    public CpmBannerCampaignBaseMap() {
        super();
    }

    public T withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        JAXBElement<ArrayOfInteger> jaxbElement =
                new ObjectFactory().createCpmBannerCampaignBaseCounterIds(counterIds);
        this.put(COUNTER_IDS, jaxbElement);
        return (T) this;
    }

    public T withCounterIds(Integer... items) {
        ArrayOfIntegerMap arrayOfIntegerMap = (items == null) ? null : new ArrayOfIntegerMap().withItems(items);
        return this.withCounterIds(arrayOfIntegerMap);
    }

    public T withFrequencyCap(FrequencyCapSettingMap frequencyCapMap) {
        FrequencyCapSetting frequencyCap =
                (FrequencyCapSetting) ((frequencyCapMap == null) ? null : frequencyCapMap.getBean());
        JAXBElement<FrequencyCapSetting> jaxbElement =
                new ObjectFactory().createCpmBannerCampaignBaseFrequencyCap(frequencyCap);
        this.put(FREQUENCY_CAP, jaxbElement);
        return (T) this;
    }
}
