package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSearchStrategyTypeEnum;

/**
 * Created by gerdler on 08.09.18.
 */
public class CpmBannerCampaignSearchStrategyMap extends DynamicTextCampaignStrategyAddBaseMap<CpmBannerCampaignSearchStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public CpmBannerCampaignSearchStrategyMap() {
        super();
        setBean(new CpmBannerCampaignSearchStrategy());
    }

    public CpmBannerCampaignSearchStrategyMap(
            CpmBannerCampaignSearchStrategy cpmBannerCampaignSearchStrategy)
    {
        super();
        setBean(cpmBannerCampaignSearchStrategy);
    }

    public CpmBannerCampaignSearchStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public CpmBannerCampaignSearchStrategyMap withBiddingStrategyType(
            CpmBannerCampaignSearchStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public CpmBannerCampaignSearchStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }
}
