package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DailyBudget;
import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 05.08.15.
 */
public class DailyBudgetMap extends ModelBeanMap<DailyBudgetMap> {
    private static final String DAY_BUDGET = "DayBudget";

    public static final String AMOUNT = "amount";
    public static final String MODE = "mode";

    public static final String AMOUNT_IN_ERROR = "DailyBudget Amount";


    public DailyBudgetMap() {
        super();
        setBean(new DailyBudget());
    }

    public DailyBudgetMap(DailyBudget dailyBudget) {
        super();
        setBean(dailyBudget);
    }

    public DailyBudgetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DailyBudgetMap withAmount(Long amount) {
        this.put(AMOUNT, amount);
        return this;
    }

    public DailyBudgetMap withMode(DailyBudgetModeEnum mode) {
        this.put(MODE, mode);
        return this;
    }

    public DailyBudgetMap defaultDailyBudget() {
        return this.withAmount(0L).withMode(DailyBudgetModeEnum.STANDARD);
    }
}
