package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.ArrayOfIntegerMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignBaseMap<T> extends ModelBeanMap<DynamicTextCampaignBaseMap> {

    public static final String COUNTER_IDS = "counterIds";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public DynamicTextCampaignBaseMap() {
        super();
    }

    public T withCounterIds(ArrayOfIntegerMap arrayOfIntegerMap) {
        ArrayOfInteger counterIds =
                (ArrayOfInteger) ((arrayOfIntegerMap == null) ? null : arrayOfIntegerMap.getBean());
        JAXBElement<ArrayOfInteger> jaxbElement =
                new ObjectFactory().createDynamicTextCampaignBaseCounterIds(counterIds);
        this.put(COUNTER_IDS, jaxbElement);
        return (T) this;
    }

    public T withCounterIds(Integer... items) {
        ArrayOfIntegerMap arrayOfIntegerMap = (items == null) ? null : new ArrayOfIntegerMap().withItems(items);
        return this.withCounterIds(arrayOfIntegerMap);
    }

    public T withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return (T) this;
    }
}
