package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.PlacementType;
import com.yandex.direct.api.v5.campaigns.PlacementTypeArray;
import com.yandex.direct.api.v5.campaigns.PriorityGoalsArray;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.web.api.models.PlacementBlock;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignGetItemMap extends DynamicTextCampaignBaseMap<DynamicTextCampaignGetItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";
    public static final String PLACEMENT_TYPES = "placementTypes";

    public DynamicTextCampaignGetItemMap() {
        setBean(new DynamicTextCampaignGetItem());
    }

    public DynamicTextCampaignGetItemMap(DynamicTextCampaignGetItem dynamicTextCampaignGetItem) {
        super();
        setBean(dynamicTextCampaignGetItem);
    }

    public DynamicTextCampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignGetItemMap withBiddingStrategy(
            DynamicTextCampaignStrategyMap dynamicTextCampaignStrategyMap)
    {
        DynamicTextCampaignStrategy dynamicTextCampaignStrategy =
                ((dynamicTextCampaignStrategyMap == null) ? null
                        : (DynamicTextCampaignStrategy) (dynamicTextCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, dynamicTextCampaignStrategy);
        return this;
    }

    public DynamicTextCampaignGetItemMap withSettings(DynamicTextCampaignSettingGetMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public DynamicTextCampaignGetItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        PriorityGoalsArray priorityGoalsArray = (PriorityGoalsArray)
                ((priorityGoalsArrayMap == null) ? null
                        : priorityGoalsArrayMap.getBean());
        JAXBElement<PriorityGoalsArray> jaxbElement =
                new ObjectFactory().createDynamicTextCampaignGetItemPriorityGoals(priorityGoalsArray);
        return this.put(PRIORITY_GOALS, jaxbElement);
    }

    public DynamicTextCampaignGetItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        PriorityGoalsArrayMap priorityGoalsArray =
                (priorityGoals == null) ? null : new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(priorityGoalsArray);
    }

    public DynamicTextCampaignGetItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }

    public DynamicTextCampaignGetItemMap withPlacementTypes(PlacementTypeArrayMap placementTypes) {
        PlacementTypeArray placementType = (PlacementTypeArray)
                ((placementTypes == null) ? null
                        : placementTypes.getBean());
        this.put(PLACEMENT_TYPES, placementType);
        return this;
    }

    public DynamicTextCampaignGetItemMap defaultDynamicTextCampaign() {
        return this.withBiddingStrategy(new DynamicTextCampaignStrategyMap().defaultDynamicTextCampaignStrategy());
    }
}
