package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PlacementType;
import com.yandex.direct.api.v5.campaigns.PlacementTypesEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class DynamicTextCampaignPlacementTypeMap extends ModelBeanMap<DynamicTextCampaignPlacementTypeMap> {

    public static final String TYPE = "type";
    public static final String VALUE = "value";

    public DynamicTextCampaignPlacementTypeMap() {
        super();
        setBean(new PlacementType());
    }

    public DynamicTextCampaignPlacementTypeMap(PlacementType placementType) {
        super();
        setBean(placementType);
    }

    public DynamicTextCampaignPlacementTypeMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignPlacementTypeMap withType(PlacementTypesEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public DynamicTextCampaignPlacementTypeMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
