package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignStrategyAddMap extends ModelBeanMap<DynamicTextCampaignStrategyAddMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public DynamicTextCampaignStrategyAddMap() {
        super();
        setBean(new DynamicTextCampaignStrategyAdd());
    }

    public DynamicTextCampaignStrategyAddMap(DynamicTextCampaignStrategyAdd dynamicTextCampaignStrategyAdd) {
        super();
        setBean(dynamicTextCampaignStrategyAdd);
    }

    public DynamicTextCampaignStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignStrategyAddMap withSearch(
            DynamicTextCampaignSearchStrategyAddMap dynamicTextCampaignSearchStrategyAddMap)
    {
        DynamicTextCampaignSearchStrategyAdd dynamicTextCampaignSearchStrategyAdd =
                ((dynamicTextCampaignSearchStrategyAddMap == null) ? null
                        : (DynamicTextCampaignSearchStrategyAdd) (dynamicTextCampaignSearchStrategyAddMap.getBean()));
        this.put(SEARCH, dynamicTextCampaignSearchStrategyAdd);
        return this;
    }

    public DynamicTextCampaignStrategyAddMap withNetwork(
            DynamicTextCampaignNetworkStrategyAddMap dynamicTextCampaignNetworkStrategyAddMap)
    {
        DynamicTextCampaignNetworkStrategyAdd dynamicTextCampaignNetworkStrategyAdd =
                ((dynamicTextCampaignNetworkStrategyAddMap == null) ? null
                        : (DynamicTextCampaignNetworkStrategyAdd) (dynamicTextCampaignNetworkStrategyAddMap.getBean()));
        this.put(NETWORK, dynamicTextCampaignNetworkStrategyAdd);
        return this;
    }

    public DynamicTextCampaignStrategyAddMap defaultDynamicTextCampaignStrategy() {
        return this
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF));
    }
}
