package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignStrategyMap extends ModelBeanMap<DynamicTextCampaignStrategyMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public DynamicTextCampaignStrategyMap() {
        super();
        setBean(new DynamicTextCampaignStrategy());
    }

    public DynamicTextCampaignStrategyMap(DynamicTextCampaignStrategy dynamicTextCampaignStrategy) {
        super();
        setBean(dynamicTextCampaignStrategy);
    }

    public DynamicTextCampaignStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public DynamicTextCampaignStrategyMap withSearch(
            DynamicTextCampaignSearchStrategyMap dynamicTextCampaignSearchStrategyMap)
    {
        DynamicTextCampaignSearchStrategy dynamicTextCampaignSearchStrategy =
                ((dynamicTextCampaignSearchStrategyMap == null) ? null
                        : (DynamicTextCampaignSearchStrategy) (dynamicTextCampaignSearchStrategyMap.getBean()));
        this.put(SEARCH, dynamicTextCampaignSearchStrategy);
        return this;
    }

    public DynamicTextCampaignStrategyMap withNetwork(
            DynamicTextCampaignNetworkStrategyMap dynamicTextCampaignNetworkStrategyMap)
    {
        DynamicTextCampaignNetworkStrategy dynamicTextCampaignNetworkStrategy =
                ((dynamicTextCampaignNetworkStrategyMap == null) ? null
                        : (DynamicTextCampaignNetworkStrategy) (dynamicTextCampaignNetworkStrategyMap.getBean()));
        this.put(NETWORK, dynamicTextCampaignNetworkStrategy);
        return this;
    }

    public DynamicTextCampaignStrategyMap defaultDynamicTextCampaignStrategy() {
        return this
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF));
    }
}
