package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.EmailSettings;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class EmailSettingsMap extends ModelBeanMap<EmailSettingsMap> {

    public static final String EMAIL = "email";
    public static final String CHECK_POSITION_INTERVAL = "checkPositionInterval";
    public static final String WARNING_BALANCE = "warningBalance";
    public static final String SEND_ACCOUNT_NEWS = "sendAccountNews";
    public static final String SEND_WARNINGS = "sendWarnings";

    public static final String DEFAULT_EMAIL = "at-tester@yandex-team.ru";
    public static final YesNoEnum DEFAULT_SEND_ACCOUNT_NEWS = YesNoEnum.YES;
    public static final YesNoEnum DEFAULT_SEND_WARNINGS = YesNoEnum.YES;

    public static final int MIN_WARNING_BALANCE = 1;
    public static final int MAX_WARNING_BALANCE = 50;

    public EmailSettingsMap() {
        super();
        setBean(new EmailSettings());
    }

    public EmailSettingsMap(EmailSettings emailSettings) {
        super();
        setBean(emailSettings);
    }

    public EmailSettingsMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public EmailSettingsMap withEmail(String email) {
        this.put(EMAIL, email);
        return this;
    }

    public EmailSettingsMap withCheckPositionInterval(Integer checkPositionInterval) {
        this.put(CHECK_POSITION_INTERVAL, checkPositionInterval);
        return this;
    }

    public EmailSettingsMap withWarningBalance(Integer warningBalance) {
        this.put(WARNING_BALANCE, warningBalance);
        return this;
    }

    public EmailSettingsMap withSendAccountNews(YesNoEnum sendAccountNews) {
        this.put(SEND_ACCOUNT_NEWS, sendAccountNews);
        return this;
    }

    public EmailSettingsMap withSendWarnings(YesNoEnum sendWarnings) {
        this.put(SEND_WARNINGS, sendWarnings);
        return this;
    }

    public EmailSettingsMap defaultEmailSettings() {
        return this
                .withEmail(DEFAULT_EMAIL)
                .withSendAccountNews(DEFAULT_SEND_ACCOUNT_NEWS)
                .withSendWarnings(DEFAULT_SEND_WARNINGS);
    }
}