package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.FrequencyCapSetting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class FrequencyCapSettingAddMap extends ModelBeanMap<FrequencyCapSettingAddMap> {
    public static final String IMPRESSIONS = "impressions";
    public static final String PERIOD_DAYS = "periodDays";

    public FrequencyCapSettingAddMap() {
        super();
        setBean(new FrequencyCapSetting());
    }

    public FrequencyCapSettingAddMap(FrequencyCapSetting frequencyCapSetting) {
        super();
        setBean(frequencyCapSetting);
    }

    public FrequencyCapSettingAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public FrequencyCapSettingAddMap withImpressions(Integer impressions) {
        this.put(IMPRESSIONS, impressions);
        return this;
    }

    public FrequencyCapSettingAddMap withPeriodDays(Integer periodDays) {
        this.put(PERIOD_DAYS, periodDays);
        return this;
    }
}
