package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.FrequencyCapSetting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class FrequencyCapSettingMap extends ModelBeanMap<FrequencyCapSettingMap> {
    public static final String IMPRESSIONS = "impressions";
    public static final String PERIOD_DAYS = "periodDays";

    public FrequencyCapSettingMap() {
        super();
        setBean(new FrequencyCapSetting());
    }

    public FrequencyCapSettingMap(FrequencyCapSetting frequencyCapSetting) {
        super();
        setBean(frequencyCapSetting);
    }

    public FrequencyCapSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public FrequencyCapSettingMap withImpressions(Integer impressions) {
        this.put(IMPRESSIONS, impressions);
        return this;
    }

    public FrequencyCapSettingMap withPeriodDays(Integer periodDays) {
        this.put(PERIOD_DAYS, periodDays);
        return this;
    }
}
