package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignFundsParam;
import com.yandex.direct.api.v5.campaigns.FundsParam;
import com.yandex.direct.api.v5.campaigns.SharedAccountFundsParam;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by ginger on 26.08.15.
 */
public class FundsParamMap extends ModelBeanMap<FundsParamMap> {

    public static final String MODE = "mode";
    public static final String CAMPAIGN_FUNDS = "campaignFunds";
    public static final String SHARED_ACCOUNT_FUNDS = "sharedAccountFunds";

    public FundsParamMap() {
        super();
        setBean(new FundsParam());
    }

    public FundsParamMap(FundsParam fundsParam) {
        super();
        setBean(fundsParam);
    }

    public FundsParamMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public FundsParamMap withMode(CampaignFundsEnum mode) {
        this.put(MODE, mode);
        return this;
    }

    public FundsParamMap withCampaignFunds(CampaignFundsParamMap campaignFundsParamMap) {
        CampaignFundsParam campaignFundsParam =
                ((campaignFundsParamMap == null) ? null : (CampaignFundsParam) (campaignFundsParamMap.getBean()));
        this.put(CAMPAIGN_FUNDS, campaignFundsParam);
        return this;
    }

    public FundsParamMap withSharedAccountFunds(SharedAccountFundsParamMap sharedAccountFundsParamMap) {
        SharedAccountFundsParam sharedAccountFundsParam =
                ((sharedAccountFundsParamMap == null) ? null
                        : (SharedAccountFundsParam) (sharedAccountFundsParamMap.getBean()));
        this.put(SHARED_ACCOUNT_FUNDS, sharedAccountFundsParam);
        return this;
    }
}
