package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetRequest;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by ginger on 22.07.15.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String TEXT_CAMPAIGN_FIELD_NAMES = "textCampaignFieldNames";
    public static final String MOBILE_APP_CAMPAIGN_FIELD_NAMES = "mobileAppCampaignFieldNames";
    public static final String DYNAMIC_TEXT_CAMPAIGN_FIELD_NAMES = "dynamicTextCampaignFieldNames";
    public static final String CPM_BANNER_CAMPAIGN_FIELD_NAMES = "cpmBannerCampaignFieldNames";
    public static final String SMART_CAMPAIGN_FIELD_NAMES = "smartCampaignFieldNames";


    public GetRequestMap() {
        super();
        setBean(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        super();
        setBean(getRequest);
    }

    public GetRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public GetRequestMap withSelectionCriteria(CampaignsSelectionCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }

    public GetRequestMap withFieldNames(CampaignFieldEnum... fieldNames) {
        this.put(FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllFieldNames() {
        this.put(FIELD_NAMES, Arrays.asList(CampaignFieldEnum.class.getEnumConstants()));
        return this;
    }


    public GetRequestMap withTextCampaignFieldNames(TextCampaignFieldEnum... fieldNames) {
        this.put(TEXT_CAMPAIGN_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllTextCampaignFieldNames() {
        this.put(TEXT_CAMPAIGN_FIELD_NAMES, Arrays.asList(TextCampaignFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum... fieldNames) {
        this.put(DYNAMIC_TEXT_CAMPAIGN_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllDynamicTextCampaignFieldNames() {
        this.put(DYNAMIC_TEXT_CAMPAIGN_FIELD_NAMES,
                Arrays.asList(DynamicTextCampaignFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum... fieldNames) {
        this.put(MOBILE_APP_CAMPAIGN_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllMobileAppCampaignFieldNames() {
        this.put(MOBILE_APP_CAMPAIGN_FIELD_NAMES, Arrays.asList(MobileAppCampaignFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum... fieldNames) {
        this.put(CPM_BANNER_CAMPAIGN_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllCpmCampaignFieldNames() {
        this.put(CPM_BANNER_CAMPAIGN_FIELD_NAMES, Arrays.asList(CpmBannerCampaignFieldEnum.class.getEnumConstants()));
        return this;
    }

    public GetRequestMap withSmartCampaignFieldNames(SmartCampaignFieldEnum... fieldNames) {
        this.put(SMART_CAMPAIGN_FIELD_NAMES, Arrays.asList(fieldNames));
        return this;
    }

    public GetRequestMap withAllSmartCampaignFieldNames() {
        this.put(SMART_CAMPAIGN_FIELD_NAMES,
                Arrays.asList(SmartCampaignFieldEnum.class.getEnumConstants()));
        return this;
    }
}
