package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.StrategyNetworkDefaultAdd;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignNetworkStrategyAddMap extends MobileAppCampaignStrategyAddBaseMap<MobileAppCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String NETWORK_DEFAULT = "networkDefault";

    public MobileAppCampaignNetworkStrategyAddMap() {
        super();
        setBean(new MobileAppCampaignNetworkStrategyAdd());
    }

    public MobileAppCampaignNetworkStrategyAddMap(
            MobileAppCampaignNetworkStrategyAdd mobileAppCampaignNetworkStrategy)
    {
        super();
        setBean(mobileAppCampaignNetworkStrategy);
    }

    public MobileAppCampaignNetworkStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignNetworkStrategyAddMap withNetworkDefault(
            StrategyNetworkDefaultAddMap StrategyNetworkDefaultAddMap)
    {
        StrategyNetworkDefaultAdd networkDefaultParams =
                ((StrategyNetworkDefaultAddMap == null) ? null
                        : (StrategyNetworkDefaultAdd) (StrategyNetworkDefaultAddMap.getBean()));
        this.put(NETWORK_DEFAULT, networkDefaultParams);
        return this;
    }

    public MobileAppCampaignNetworkStrategyAddMap withBiddingStrategyType(
            MobileAppCampaignNetworkStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultMaximumCoverage() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultNetworkDefault() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap());
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultNetworkDefaultWithLimitPercent() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap()
                        .defaultStrategyNetworkDefault());
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultWbMaximumAppInstalls(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsAddMap()
                        .defaultStrategyMaximumAppInstalls(currency));
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultAverageCpi(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPI)
                .withAverageCpi(new StrategyAverageCpiAddMap()
                        .defaultStrategyAverageCpi(currency));
    }

}
