package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.money.Currency;

/**
 * Created by pavryabov on 19.10.15.
 */
public class MobileAppCampaignSearchStrategyMap extends MobileAppCampaignStrategyBaseMap<MobileAppCampaignSearchStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public MobileAppCampaignSearchStrategyMap() {
        super();
        setBean(new MobileAppCampaignSearchStrategy());
    }

    public MobileAppCampaignSearchStrategyMap(MobileAppCampaignSearchStrategy mobileAppCampaignSearchStrategy) {
        super();
        setBean(mobileAppCampaignSearchStrategy);
    }

    public MobileAppCampaignSearchStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignSearchStrategyMap withBiddingStrategyType(
            MobileAppCampaignSearchStrategyTypeEnum biddingStrategyType)
    {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public MobileAppCampaignSearchStrategyMap defaultServingOff() {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }

    public MobileAppCampaignSearchStrategyMap defaultHighestPosition() {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public MobileAppCampaignSearchStrategyMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public MobileAppCampaignSearchStrategyMap defaultWbMaximumAppInstalls(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsMap()
                        .defaultStrategyMaximumAppInstalls(currency));
    }

    public MobileAppCampaignSearchStrategyMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public MobileAppCampaignSearchStrategyMap defaultAverageCpi(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPI)
                .withAverageCpi(new StrategyAverageCpiMap()
                        .defaultStrategyAverageCpi(currency));
    }

}
