package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 30.09.15.
 */
public class MobileAppCampaignSettingGetMap extends ModelBeanMap<MobileAppCampaignSettingGetMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public MobileAppCampaignSettingGetMap() {
        super();
        setBean(new MobileAppCampaignSettingGet());
    }

    public MobileAppCampaignSettingGetMap(MobileAppCampaignSettingGet mobileAppCampaignSettingGet) {
        super();
        setBean(mobileAppCampaignSettingGet);
    }

    public MobileAppCampaignSettingGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignSettingGetMap withOption(MobileAppCampaignSettingsGetEnum campaignPropertiesEnum) {
        this.put(OPTION, campaignPropertiesEnum);
        return this;
    }

    public MobileAppCampaignSettingGetMap withValue(YesNoEnum yesNoEnum) {
        this.put(VALUE, yesNoEnum);
        return this;
    }
}