package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSetting;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignSettingMap extends ModelBeanMap<MobileAppCampaignSettingMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public MobileAppCampaignSettingMap() {
        super();
        setBean(new MobileAppCampaignSetting());
    }

    public MobileAppCampaignSettingMap(MobileAppCampaignSetting mobileAppCampaignSetting) {
        super();
        setBean(mobileAppCampaignSetting);
    }

    public MobileAppCampaignSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignSettingMap withOption(MobileAppCampaignSettingsEnum option) {
        this.put(OPTION, option);
        return this;
    }

    public MobileAppCampaignSettingMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}