package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 19.10.15.
 */
public class MobileAppCampaignStrategyMap extends ModelBeanMap<MobileAppCampaignStrategyMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public MobileAppCampaignStrategyMap() {
        super();
        setBean(new MobileAppCampaignStrategy());
    }

    public MobileAppCampaignStrategyMap(MobileAppCampaignStrategy mobileAppCampaignStrategy) {
        super();
        setBean(mobileAppCampaignStrategy);
    }

    public MobileAppCampaignStrategyMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignStrategyMap withSearch(
            MobileAppCampaignSearchStrategyMap mobileAppCampaignSearchStrategyMap)
    {
        MobileAppCampaignSearchStrategy mobileAppCampaignSearchStrategy =
                ((mobileAppCampaignSearchStrategyMap == null) ? null
                        : (com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategy) (mobileAppCampaignSearchStrategyMap
                                .getBean()));
        this.put(SEARCH, mobileAppCampaignSearchStrategy);
        return this;
    }

    public MobileAppCampaignStrategyMap withNetwork(
            MobileAppCampaignNetworkStrategyMap mobileAppCampaignNetworkStrategyMap)
    {
        MobileAppCampaignNetworkStrategy mobileAppCampaignNetworkStrategy =
                ((mobileAppCampaignNetworkStrategyMap == null) ? null
                        : (MobileAppCampaignNetworkStrategy) (mobileAppCampaignNetworkStrategyMap.getBean()));
        this.put(NETWORK, mobileAppCampaignNetworkStrategy);
        return this;
    }

    public MobileAppCampaignStrategyMap defaultMobileAppCampaignStrategy() {
        return this
                .withSearch(new MobileAppCampaignSearchStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new MobileAppCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE));
    }
}
