package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignUpdateItem;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by pavryabov on 24.09.15.
 */
public class MobileAppCampaignUpdateItemMap extends ModelBeanMap<MobileAppCampaignUpdateItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";

    public MobileAppCampaignUpdateItemMap() {
        super();
        setBean(new MobileAppCampaignUpdateItem());
    }

    public MobileAppCampaignUpdateItemMap(MobileAppCampaignUpdateItem mobileAppCampaignUpdateItem) {
        super();
        setBean(mobileAppCampaignUpdateItem);
    }

    public MobileAppCampaignUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public MobileAppCampaignUpdateItemMap withBiddingStrategy(
            MobileAppCampaignStrategyMap mobileAppCampaignStrategyMap)
    {
        MobileAppCampaignStrategy mobileAppCampaignStrategy =
                ((mobileAppCampaignStrategyMap == null) ? null
                        : (MobileAppCampaignStrategy) (mobileAppCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, mobileAppCampaignStrategy);
        return this;
    }

    public MobileAppCampaignUpdateItemMap withSettings(MobileAppCampaignSettingMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }
}
