package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.EmailSettings;
import com.yandex.direct.api.v5.campaigns.Notification;
import com.yandex.direct.api.v5.campaigns.SmsSettings;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class NotificationMap extends ModelBeanMap<NotificationMap> {

    public static final String SMS_SETTINGS = "smsSettings";
    public static final String EMAIL_SETTINGS = "emailSettings";

    public NotificationMap() {
        super();
        setBean(new Notification());
    }

    public NotificationMap(Notification notification) {
        super();
        setBean(notification);
    }

    public NotificationMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public NotificationMap withSmsSettings(SmsSettingsMap smsSettingsMap) {
        SmsSettings smsSettings =
                ((smsSettingsMap == null) ? null : (SmsSettings) (smsSettingsMap.getBean()));
        this.put(SMS_SETTINGS, smsSettings);
        return this;
    }

    public NotificationMap withEmailSettings(EmailSettingsMap emailSettingsMap) {
        EmailSettings emailSettings =
                ((emailSettingsMap == null) ? null : (EmailSettings) (emailSettingsMap.getBean()));
        this.put(EMAIL_SETTINGS, emailSettings);
        return this;
    }

    public NotificationMap defaultNotification() {
        return this
                .withEmailSettings(new EmailSettingsMap().defaultEmailSettings())
                .withSmsSettings(new SmsSettingsMap().defaultSmsSettings());
    }
}
