package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PlacementTypeArray;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;
import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

import static ch.lambdaj.Lambda.convert;

/**
 * Created by gerdler on 22.11.21.
 */
public class PlacementTypeArrayMap extends ModelBeanMap<PlacementTypeArrayMap> {

    public static final String PLACEMENT_TYPE_ARRAY_ITEMS = "items";

    public PlacementTypeArrayMap() {
        super();
        setBean(new PlacementTypeArray());
    }

    public PlacementTypeArrayMap(PlacementTypeArray placementTypeArray) {
        super();
        setBean(placementTypeArray);
    }

    public PlacementTypeArrayMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PlacementTypeArrayMap withItems(PlacementTypeItemMap... items) {
        this.put(PLACEMENT_TYPE_ARRAY_ITEMS, (items == null) ? null : convert(items, new BeanMapToBeanConverter()));
        return this;
    }
}
