package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PlacementType;
import com.yandex.direct.api.v5.campaigns.PlacementTypesEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by gerdler on 22.11.21.
 */
public class PlacementTypeItemMap extends ModelBeanMap<PlacementTypeItemMap> {

    public static final String TYPE = "type";
    public static final String VALUE = "value";

    public PlacementTypeItemMap() {
        super();
        setBean(new PlacementType());
    }

    public PlacementTypeItemMap(PlacementType placementType) {
        super();
        setBean(placementType);
    }

    public PlacementTypeItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PlacementTypeItemMap withType(PlacementTypesEnum type) {
        this.put(TYPE, type);
        return this;
    }

    public PlacementTypeItemMap withValue(YesNoEnum value) {
        this.put(VALUE, value);
        return this;
    }
}
