package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PriorityGoalsItem;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by liosha on 21.12.18.
 */
public class PriorityGoalsItemMap extends ModelBeanMap<PriorityGoalsItemMap> {

    public static final String GOAL_ID = "goalId";
    public static final String VALUE = "value";
    public static final String IS_METRIKA_SOURCE_OF_VALUE = "isMetrikaSourceOfValue";

    public static final Long ENGAGED_SESSION_GOAL_ID = 12L;

    public PriorityGoalsItemMap() {
        super();
        setBean(new PriorityGoalsItem());
    }

    public PriorityGoalsItemMap(PriorityGoalsItem priorityGoal) {
        super();
        setBean(priorityGoal);
    }

    public PriorityGoalsItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriorityGoalsItemMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public PriorityGoalsItemMap withEngagedSessionGoalId() {
        this.put(GOAL_ID, ENGAGED_SESSION_GOAL_ID);
        return this;
    }

    public PriorityGoalsItemMap withValue(Long value) {
        this.put(VALUE, value);
        return this;
    }

    public PriorityGoalsItemMap withIsMetrikaSourceOfValue(YesNoEnum value) {
        this.put(IS_METRIKA_SOURCE_OF_VALUE, value);
        return this;
    }
}
