package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PriorityGoalsUpdateItem;
import com.yandex.direct.api.v5.general.OperationEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;


/**
 * Created by liosha on 21.12.18.
 */
public class PriorityGoalsUpdateItemMap extends ModelBeanMap<PriorityGoalsUpdateItemMap> {

    public static final String GOAL_ID = "goalId";
    public static final String VALUE = "value";
    public static final String IS_METRIKA_SOURCE_OF_VALUE = "isMetrikaSourceOfValue";
    public static final String OPERATION = "operation";

    public static final Long ENGAGED_SESSION_GOAL_ID = 12L;

    public PriorityGoalsUpdateItemMap() {
        super();
        setBean(new PriorityGoalsUpdateItem());
    }

    public PriorityGoalsUpdateItemMap(PriorityGoalsUpdateItem priorityGoalsUpdateItem) {
        super();
        setBean(priorityGoalsUpdateItem);
    }

    public PriorityGoalsUpdateItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public PriorityGoalsUpdateItemMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public PriorityGoalsUpdateItemMap withEngagedSessionGoalId() {
        this.put(GOAL_ID, ENGAGED_SESSION_GOAL_ID);
        return this;
    }

    public PriorityGoalsUpdateItemMap withValue(Long value) {
        this.put(VALUE, value);
        return this;
    }

    public PriorityGoalsUpdateItemMap withIsMetrikaSourceOfValue(YesNoEnum value) {
        this.put(IS_METRIKA_SOURCE_OF_VALUE, value);
        return this;
    }


    public PriorityGoalsUpdateItemMap withOperation(OperationEnum operation) {
        this.put(OPERATION, operation);
        return this;
    }
}
