package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsSettingAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class RelevantKeywordsSettingAddMap extends ModelBeanMap<RelevantKeywordsSettingAddMap> {
    public static final String BUDGET_PERCENT = "budgetPercent";
    public static final String MODE = "mode";
    public static final String OPTIMIZE_GOAL_ID = "optimizeGoalId";

    public RelevantKeywordsSettingAddMap() {
        super();
        setBean(new RelevantKeywordsSettingAdd());
    }

    public RelevantKeywordsSettingAddMap(RelevantKeywordsSettingAdd relevantKeywordsSettingAdd) {
        super();
        setBean(relevantKeywordsSettingAdd);
    }

    public RelevantKeywordsSettingAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RelevantKeywordsSettingAddMap withBudgetPercent(Integer budgetPercent) {
        this.put(BUDGET_PERCENT, budgetPercent);
        return this;
    }

    public RelevantKeywordsSettingAddMap withMode(RelevantKeywordsModeEnum mode) {
        this.put(MODE, mode);
        return this;
    }

    public RelevantKeywordsSettingAddMap withOptimizeGoalId(Long optimizeGoalId) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createRelevantKeywordsSettingOptimizeGoalId(optimizeGoalId);
        this.put(OPTIMIZE_GOAL_ID, jaxbElement);
        return this;
    }
}
