package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsSetting;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

/**
 * Created by pavryabov on 05.08.15.
 */
public class RelevantKeywordsSettingMap extends ModelBeanMap<RelevantKeywordsSettingMap> {

    public static final String BUDGET_PERCENT = "budgetPercent";
    public static final String MODE = "mode";
    public static final String OPTIMIZE_GOAL_ID = "optimizeGoalId";
    public static final int MIN_BUDGET_PERCENT = 1;
    public static final int MAX_BUDGET_PERCENT = 100;

    public RelevantKeywordsSettingMap() {
        super();
        setBean(new RelevantKeywordsSetting());
    }

    public RelevantKeywordsSettingMap(RelevantKeywordsSetting relevantKeywordsSetting) {
        super();
        setBean(relevantKeywordsSetting);
    }

    public RelevantKeywordsSettingMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public RelevantKeywordsSettingMap withBudgetPercent(Integer budgetPercent) {
        this.put(BUDGET_PERCENT, budgetPercent);
        return this;
    }

    public RelevantKeywordsSettingMap withMode(RelevantKeywordsModeEnum mode) {
        this.put(MODE, mode);
        return this;
    }

    public RelevantKeywordsSettingMap withOptimizeGoalId(Long optimizeGoalId) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createRelevantKeywordsSettingOptimizeGoalId(optimizeGoalId);
        this.put(OPTIMIZE_GOAL_ID, jaxbElement);
        return this;
    }

}
