package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ResumeRequest;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;

/**
 * Created by chicos on 14.08.15.
 */
public class ResumeRequestMap extends ModelBeanMap<ResumeRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";

    public ResumeRequestMap() {
        super();
        setBean(new ResumeRequest());
    }

    public ResumeRequestMap(ResumeRequest resumeRequest) {
        super();
        setBean(resumeRequest);
    }

    public ResumeRequestMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public ResumeRequestMap withSelectionCriteria(IdsCriteriaMap selectionCriteria) {
        this.put(SELECTION_CRITERIA,
                (selectionCriteria == null) ? null : selectionCriteria.getBean());
        return this;
    }
}
