package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.PriorityGoalsArray;
import com.yandex.direct.api.v5.campaigns.SmartCampaignGetItem;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import ru.yandex.autotests.direct.utils.converter.BeanMapToBeanConverter;

import static ch.lambdaj.Lambda.convert;

@ParametersAreNonnullByDefault
public class SmartCampaignGetItemMap extends SmartCampaignBaseMap<SmartCampaignGetItemMap> {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String PRIORITY_GOALS = "priorityGoals";

    public SmartCampaignGetItemMap() {
        setBean(new SmartCampaignGetItem());
    }

    public SmartCampaignGetItemMap(SmartCampaignGetItem smartCampaignGetItem) {
        super();
        setBean(smartCampaignGetItem);
    }

    public SmartCampaignGetItemMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignGetItemMap withBiddingStrategy(
            SmartCampaignStrategyMap smartCampaignStrategyMap) {
        DynamicTextCampaignStrategy smartCampaignStrategy =
                ((smartCampaignStrategyMap == null) ? null
                        : (DynamicTextCampaignStrategy) (smartCampaignStrategyMap.getBean()));
        this.put(BIDDING_STRATEGY, smartCampaignStrategy);
        return this;
    }

    public SmartCampaignGetItemMap withSettings(SmartCampaignSettingGetMap... settings) {
        this.put(SETTINGS, (settings == null) ? null : convert(settings, new BeanMapToBeanConverter()));
        return this;
    }

    public SmartCampaignGetItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        PriorityGoalsArray priorityGoalsArray = (PriorityGoalsArray)
                ((priorityGoalsArrayMap == null) ? null
                        : priorityGoalsArrayMap.getBean());
        JAXBElement<PriorityGoalsArray> jaxbElement =
                new ObjectFactory().createSmartCampaignGetItemPriorityGoals(priorityGoalsArray);
        return this.put(PRIORITY_GOALS, jaxbElement);
    }

    public SmartCampaignGetItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        PriorityGoalsArrayMap priorityGoalsArray =
                (priorityGoals == null) ? null : new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(priorityGoalsArray);
    }

    public SmartCampaignGetItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        this.put(ATTRIBUTION_MODEL, attributionModel);
        return this;
    }

    public SmartCampaignGetItemMap defaultSmartCampaign() {
        return this.withBiddingStrategy(new SmartCampaignStrategyMap().defaultSmartCampaignStrategy());
    }
}
