package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignNetworkStrategyAddMap extends SmartCampaignStrategyAddBaseMap<SmartCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public SmartCampaignNetworkStrategyAddMap() {
        super();
        setBean(new SmartCampaignNetworkStrategyAdd());
    }

    public SmartCampaignNetworkStrategyAddMap(
            SmartCampaignNetworkStrategyAdd smartCampaignNetworkStrategyAdd) {
        super();
        setBean(smartCampaignNetworkStrategyAdd);
    }

    public SmartCampaignNetworkStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignNetworkStrategyAddMap withBiddingStrategyType(
            SmartCampaignNetworkStrategyTypeEnum biddingStrategyType) {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }

    public SmartCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }
}
