package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignSearchStrategyAddMap extends SmartCampaignStrategyAddBaseMap<SmartCampaignSearchStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";

    public SmartCampaignSearchStrategyAddMap() {
        super();
        setBean(new SmartCampaignSearchStrategyAdd());
    }

    public SmartCampaignSearchStrategyAddMap(SmartCampaignSearchStrategy smartCampaignSearchStrategyAdd) {
        super();
        setBean(smartCampaignSearchStrategyAdd);
    }

    public SmartCampaignSearchStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignSearchStrategyAddMap withBiddingStrategyType(
            SmartCampaignSearchStrategyTypeEnum biddingStrategyType) {
        this.put(BIDDING_STRATEGY_TYPE, biddingStrategyType);
        return this;
    }
}
