package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignSettingGetMap extends ModelBeanMap<SmartCampaignSettingGetMap> {

    public static final String OPTION = "option";
    public static final String VALUE = "value";

    public SmartCampaignSettingGetMap() {
        super();
        setBean(new SmartCampaignSettingGet());
    }

    public SmartCampaignSettingGetMap(SmartCampaignSettingGet smartCampaignSettingGet) {
        super();
        setBean(smartCampaignSettingGet);
    }

    public SmartCampaignSettingGetMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignSettingGetMap withOption(SmartCampaignSettingsGetEnum campaignPropertiesEnum) {
        this.put(OPTION, campaignPropertiesEnum);
        return this;
    }

    public SmartCampaignSettingGetMap withValue(YesNoEnum yesNoEnum) {
        this.put(VALUE, yesNoEnum);
        return this;
    }
}
