package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerCampaignAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilterAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerCampaignAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerFilterAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCrrAdd;
import com.yandex.direct.api.v5.campaigns.StrategyAverageRoiAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrrAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerCampaignAdd;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilterAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignStrategyAddBaseMap<T> extends ModelBeanMap<SmartCampaignStrategyAddBaseMap> {

    public static final String AVERAGE_CPC_PER_CAMPAIGN = "averageCpcPerCampaign";
    public static final String AVERAGE_CPC_PER_FILTER = "averageCpcPerFilter";
    public static final String AVERAGE_CPA_PER_CAMPAIGN = "averageCpaPerCampaign";
    public static final String AVERAGE_CPA_PER_FILTER = "averageCpaPerFilter";
    public static final String PAY_FOR_CONVERSION_PER_CAMPAIGN = "payForConversionPerCampaign";
    public static final String PAY_FOR_CONVERSION_PER_FILTER = "payForConversionPerFilter";
    public static final String AVERAGE_ROI = "averageRoi";
    public static final String AVERAGE_CRR = "averageCrr";
    public static final String PAY_FOR_CONVERSION_CRR = "payForConversionCrr";

    public SmartCampaignStrategyAddBaseMap() {
        super();
    }

    public T withAverageCpcPerCampaign(StrategyAverageCpcPerCampaignAddMap paramsMap) {
        StrategyAverageCpcPerCampaignAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcPerCampaignAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withAverageCpcPerFilter(StrategyAverageCpcPerFilterAddMap paramsMap) {
        StrategyAverageCpcPerFilterAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpcPerFilterAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPC_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageCpaPerCampaign(StrategyAverageCpaPerCampaignAddMap paramsMap) {
        StrategyAverageCpaPerCampaignAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpaPerCampaignAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPA_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withAverageCpaPerFilter(StrategyAverageCpaPerFilterAddMap paramsMap) {
        StrategyAverageCpaPerFilterAdd params =
                ((paramsMap == null) ? null : (StrategyAverageCpaPerFilterAdd) (paramsMap.getBean()));
        this.put(AVERAGE_CPA_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageRoi(StrategyAverageRoiAddMap paramsMap) {
        StrategyAverageRoiAdd params =
                ((paramsMap == null) ? null : (StrategyAverageRoiAdd) (paramsMap.getBean()));
        this.put(AVERAGE_ROI, params);
        return (T) this;
    }

    public T withPayForConversionPerCampaign(StrategyPayForConversionPerCampaignAddMap paramsMap) {
        StrategyPayForConversionPerCampaignAdd params =
                ((paramsMap == null) ? null : (StrategyPayForConversionPerCampaignAdd) (paramsMap.getBean()));
        this.put(PAY_FOR_CONVERSION_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withPayForConversionPerFilter(StrategyPayForConversionPerFilterAddMap paramsMap) {
        StrategyPayForConversionPerFilterAdd params =
                ((paramsMap == null) ? null : (StrategyPayForConversionPerFilterAdd) (paramsMap.getBean()));
        this.put(PAY_FOR_CONVERSION_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageCrr(StrategyAverageCrrAddMap paramsMap) {
        StrategyAverageCrrAdd params =
                paramsMap == null ? null : (StrategyAverageCrrAdd) paramsMap.getBean();
        this.put(AVERAGE_CRR, params);
        return (T) this;
    }

    public T withPayForConversionCrr(StrategyPayForConversionCrrAddMap paramsMap) {
        StrategyPayForConversionCrrAdd params =
                paramsMap == null ? null : (StrategyPayForConversionCrrAdd) paramsMap.getBean();
        this.put(PAY_FOR_CONVERSION_CRR, params);
        return (T) this;
    }
}
