package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignStrategyAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignStrategyAddMap extends ModelBeanMap<SmartCampaignStrategyAddMap> {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";

    public SmartCampaignStrategyAddMap() {
        super();
        setBean(new SmartCampaignStrategyAdd());
    }

    public SmartCampaignStrategyAddMap(SmartCampaignStrategyAdd smartCampaignStrategyAdd) {
        super();
        setBean(smartCampaignStrategyAdd);
    }

    public SmartCampaignStrategyAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public SmartCampaignStrategyAddMap withSearch(
            SmartCampaignSearchStrategyAddMap smartCampaignSearchStrategyAddMap) {
        SmartCampaignSearchStrategyAdd smartCampaignSearchStrategyAdd =
                ((smartCampaignSearchStrategyAddMap == null) ? null
                        : (SmartCampaignSearchStrategyAdd) (smartCampaignSearchStrategyAddMap.getBean()));
        this.put(SEARCH, smartCampaignSearchStrategyAdd);
        return this;
    }

    public SmartCampaignStrategyAddMap withNetwork(
            SmartCampaignNetworkStrategyAddMap smartCampaignNetworkStrategyAddMap) {
        SmartCampaignNetworkStrategyAdd smartCampaignNetworkStrategyAdd =
                ((smartCampaignNetworkStrategyAddMap == null) ? null
                        : (SmartCampaignNetworkStrategyAdd) (smartCampaignNetworkStrategyAddMap.getBean()));
        this.put(NETWORK, smartCampaignNetworkStrategyAdd);
        return this;
    }

    public SmartCampaignStrategyAddMap defaultSmartCampaignStrategy() {
        return this
                .withSearch(new SmartCampaignSearchStrategyAddMap()
//                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.AVERAGE_CPA_PER_CAMPAIGN))
                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.SERVING_OFF))

                        .withNetwork(new SmartCampaignNetworkStrategyAddMap()
//                        .withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.SERVING_OFF));
                        .withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPC_PER_CAMPAIGN)
                            .withAverageCpcPerCampaign(new StrategyAverageCpcPerCampaignAddMap().withAverageCpc(100000000L))
                        );

    }
}
