package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerCampaign;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilter;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerCampaign;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerFilter;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCrr;
import com.yandex.direct.api.v5.campaigns.StrategyAverageRoi;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrr;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerCampaign;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilter;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;

public class SmartCampaignStrategyBaseMap<T> extends ModelBeanMap<SmartCampaignStrategyBaseMap> {

    public static final String AVERAGE_CPC_PER_CAMPAIGN = "averageCpcPerCampaign";
    public static final String AVERAGE_CPC_PER_FILTER = "averageCpcPerFilter";
    public static final String AVERAGE_CPA_PER_CAMPAIGN = "averageCpaPerCampaign";
    public static final String AVERAGE_CPA_PER_FILTER = "averageCpaPerFilter";
    public static final String AVERAGE_ROI = "averageRoi";
    public static final String PAY_FOR_CONVERSION_CRR = "payForConversionCrr";
    public static final String PAY_FOR_CONVERSION_PER_CAMPAIGN = "payForConversionPerCampaign";
    public static final String AVERAGE_CRR = "averageCrr";
    public static final String PAY_FOR_CONVERSION_PER_FILTER = "payForConversionPerFilter";

    public SmartCampaignStrategyBaseMap() {
        super();
    }

    public T withAverageCpcPerCampaign(StrategyAverageCpcPerCampaignMap paramsMap) {
        StrategyAverageCpcPerCampaign params =
                ((paramsMap == null) ? null : (StrategyAverageCpcPerCampaign) (paramsMap.getBean()));
        this.put(AVERAGE_CPC_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withAverageCpcPerFilter(StrategyAverageCpcPerFilterMap paramsMap) {
        StrategyAverageCpcPerFilter params =
                ((paramsMap == null) ? null : (StrategyAverageCpcPerFilter) (paramsMap.getBean()));
        this.put(AVERAGE_CPC_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageCpaPerCampaign(StrategyAverageCpaPerCampaignMap paramsMap) {
        StrategyAverageCpaPerCampaign params =
                ((paramsMap == null) ? null : (StrategyAverageCpaPerCampaign) (paramsMap.getBean()));
        this.put(AVERAGE_CPA_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withAverageCpaPerFilter(StrategyAverageCpaPerFilterMap paramsMap) {
        StrategyAverageCpaPerFilter params =
                ((paramsMap == null) ? null : (StrategyAverageCpaPerFilter) (paramsMap.getBean()));
        this.put(AVERAGE_CPA_PER_FILTER, params);
        return (T) this;
    }

    public T withPayForConversionCrr(StrategyPayForConversionCrrMap paramsMap) {
        StrategyPayForConversionCrr params =
                paramsMap == null ? null : (StrategyPayForConversionCrr) paramsMap.getBean();
        this.put(PAY_FOR_CONVERSION_CRR, params);
        return (T) this;
    }

    public T withAverageRoi(StrategyAverageRoiMap paramsMap) {
        StrategyAverageRoi params =
                ((paramsMap == null) ? null : (StrategyAverageRoi) (paramsMap.getBean()));
        this.put(AVERAGE_ROI, params);
        return (T) this;
    }

    public T withPayForConversionPerCampaign(StrategyPayForConversionPerCampaignMap paramsMap) {
        StrategyPayForConversionPerCampaign params =
                ((paramsMap == null) ? null : (StrategyPayForConversionPerCampaign) (paramsMap.getBean()));
        this.put(PAY_FOR_CONVERSION_PER_CAMPAIGN, params);
        return (T) this;
    }

    public T withPayForConversionPerFilter(StrategyPayForConversionPerFilterMap paramsMap) {
        StrategyPayForConversionPerFilter params =
                ((paramsMap == null) ? null : (StrategyPayForConversionPerFilter) (paramsMap.getBean()));
        this.put(PAY_FOR_CONVERSION_PER_FILTER, params);
        return (T) this;
    }

    public T withAverageCrr(StrategyAverageCrrMap paramsMap) {
        StrategyAverageCrr params =
                paramsMap == null ? null : (StrategyAverageCrr) paramsMap.getBean();
        this.put(AVERAGE_CRR, params);
        return (T) this;
    }
}
