package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilterAdd;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

@ParametersAreNonnullByDefault
public class StrategyAverageCpaPerFilterAddMap extends ModelBeanMap<StrategyAverageCpaPerFilterAddMap> {
    public static final String FILTER_AVERAGE_CPA = "filterAverageCpa";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpaPerFilterAddMap() {
        super();
        setBean(new StrategyAverageCpaPerFilterAdd());
    }

    public StrategyAverageCpaPerFilterAddMap(StrategyAverageCpaPerFilterAdd strategyAverageCpaPerFilterAdd) {
        super();
        setBean(strategyAverageCpaPerFilterAdd);
    }

    public StrategyAverageCpaPerFilterAddMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap defaultStrategyAverageCpaPerFilterAdd(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withFilterAverageCpa(averagePrice.bidLong().longValue())
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerFilterAddMap withFilterAverageCpa(Long filterAverageCpa) {
        this.put(FILTER_AVERAGE_CPA, filterAverageCpa);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap withBidCeiling(Long bidCeiling) {
        this.put(BID_CEILING, bidCeiling);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        this.put(WEEKLY_SPEND_LIMIT, weeklySpendLimit);
        return this;
    }
}
