package ru.yandex.autotests.directapi.model.api5.campaigns;

import javax.xml.bind.JAXBElement;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilter;

import ru.yandex.autotests.direct.utils.model.ModelBeanMap;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;

public class StrategyAverageCpaPerFilterMap extends ModelBeanMap<StrategyAverageCpaPerFilterMap> {
    public static final String FILTER_AVERAGE_CPA = "filterAverageCpa";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public StrategyAverageCpaPerFilterMap() {
        super();
        setBean(new StrategyAverageCpaPerFilter());
    }

    public StrategyAverageCpaPerFilterMap(StrategyAverageCpaPerFilter strategyAverageCpaPerFilter) {
        super();
        setBean(strategyAverageCpaPerFilter);
    }

    public StrategyAverageCpaPerFilterMap put(String fieldName, Object value) {
        super.put(fieldName, value);
        return this;
    }

    public StrategyAverageCpaPerFilterMap defaultStrategyAverageCpaPerFilter(Currency currency) {
        Money averagePrice = MoneyCurrency.get(currency).getMinAveragePrice();
        return this
                .withFilterAverageCpa(averagePrice.bidLong().longValue() * 10L)
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerFilterMap withFilterAverageCpa(Long filterAverageCpa) {
        this.put(FILTER_AVERAGE_CPA, filterAverageCpa);
        return this;
    }

    public StrategyAverageCpaPerFilterMap withGoalId(Long goalId) {
        this.put(GOAL_ID, goalId);
        return this;
    }

    public StrategyAverageCpaPerFilterMap withBidCeiling(Long bidCeiling) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaPerFilterBidCeiling(bidCeiling);
        this.put(BID_CEILING, jaxbElement);
        return this;
    }

    public StrategyAverageCpaPerFilterMap withWeeklySpendLimit(Long weeklySpendLimit) {
        JAXBElement<Long> jaxbElement =
                new ObjectFactory().createStrategyAverageCpaPerFilterWeeklySpendLimit(weeklySpendLimit);
        this.put(WEEKLY_SPEND_LIMIT, jaxbElement);
        return this;
    }
}
